/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.config.MutantBlazeCommonConfig;
import com.alexander.mutantmore.entities.MutantBlaze;
import com.alexander.mutantmore.entities.MutantBlazeRodProjectile;
import com.alexander.mutantmore.entities.MutantBlazeShieldPart;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class MutantBlazeFireball
extends Fireball {
    public boolean spawnedByDyingMutantBlaze;
    public float damage = 0.0f;
    public float explosionDamage = 0.0f;
    public float explosionRadius = 1.0f;
    public int fireLength = 0;
    public boolean ignoresInvulTime = true;
    public boolean griefing = true;
    public boolean griefingDropsBlocks = false;
    public boolean explosionFire = true;

    public MutantBlazeFireball(EntityType<? extends MutantBlazeFireball> p_37199_, Level p_37200_) {
        super(p_37199_, p_37200_);
    }

    public MutantBlazeFireball(Level p_181151_, LivingEntity p_181152_, double p_181153_, double p_181154_, double p_181155_) {
        super((EntityType)EntityTypeInit.MUTANT_BLAZE_FIREBALL.get(), p_181152_, p_181153_, p_181154_, p_181155_, p_181151_);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        tag.m_128350_("Damage", this.damage);
        tag.m_128350_("ExplosionDamage", this.explosionDamage);
        tag.m_128350_("ExplosionRadius", this.explosionRadius);
        tag.m_128405_("FireLength", this.fireLength);
        tag.m_128379_("IgnoresInvulTime", this.ignoresInvulTime);
        tag.m_128379_("Griefing", this.griefing);
        tag.m_128379_("GriefingDropsBlocks", this.griefingDropsBlocks);
        tag.m_128379_("ExplosionFire", this.explosionFire);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.damage = tag.m_128457_("Damage");
        this.explosionDamage = tag.m_128457_("ExplosionDamage");
        this.explosionRadius = tag.m_128457_("ExplosionRadius");
        this.fireLength = tag.m_128451_("FireLength");
        this.ignoresInvulTime = tag.m_128471_("IgnoresInvulTime");
        this.griefing = tag.m_128471_("Griefing");
        this.griefingDropsBlocks = tag.m_128471_("GriefingDropsBlocks");
        this.explosionFire = tag.m_128471_("ExplosionFire");
    }

    protected boolean m_5603_(Entity target) {
        return this.canHit(target) && super.m_5603_(target);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 10, 0.0075f, this.m_20183_(), 7, CameraShakePriority.EFFECT);
        }
        for (int i = 0; i < 2; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7107_((ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.f_19853_.f_46443_) {
            HandleLoopingSoundInstances.addMutantBlazeFireballAudio(this, this.f_19853_);
        }
    }

    protected void m_6532_(HitResult p_37218_) {
        if (!(this.f_19853_.f_46443_ || p_37218_ instanceof EntityHitResult && ((EntityHitResult)p_37218_).m_82443_() instanceof MutantBlazeShieldPart && this.f_19797_ <= 10 || this.spawnedByDyingMutantBlaze && p_37218_ instanceof EntityHitResult && (((EntityHitResult)p_37218_).m_82443_() instanceof MutantBlazeRodProjectile || ((EntityHitResult)p_37218_).m_82443_() instanceof MutantBlazeFireball))) {
            if (p_37218_ instanceof EntityHitResult && ((EntityHitResult)p_37218_).m_82443_() instanceof MutantBlazeShieldPart && this.f_19797_ > 10) {
                MiscUtils.customExplosion(this.f_19853_, (Entity)(this.m_37282_() != null ? this.m_37282_() : this), DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5f, false, Explosion.BlockInteraction.NONE, SoundEvents.f_11913_, this.m_5720_(), (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), 1.0f, true, false);
                this.m_146870_();
            } else if (p_37218_ instanceof EntityHitResult && ((EntityHitResult)p_37218_).m_82443_() instanceof MutantBlaze && this.f_19797_ > 10 && ((Boolean)MutantBlazeCommonConfig.stunnable.get()).booleanValue()) {
                ((EntityHitResult)p_37218_).m_82443_().m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_STUN_START.get(), 2.0f, MiscUtils.randomSoundPitch());
                ((MutantBlaze)((EntityHitResult)p_37218_).m_82443_()).stunnedTicks = ((MutantBlaze)((EntityHitResult)p_37218_).m_82443_()).stunnedLength;
                this.f_19853_.m_7605_((Entity)((MutantBlaze)((EntityHitResult)p_37218_).m_82443_()), (byte)12);
                MiscUtils.customExplosion(this.f_19853_, (Entity)(this.m_37282_() != null ? this.m_37282_() : this), DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5f, false, Explosion.BlockInteraction.NONE, SoundEvents.f_11913_, this.m_5720_(), (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), 1.0f, true, false);
                this.m_146870_();
            } else {
                super.m_6532_(p_37218_);
                MiscUtils.customExplosion(this.f_19853_, (Entity)(this.m_37282_() != null ? this.m_37282_() : this), DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), Mth.m_14036_((float)this.explosionRadius, (float)1.0f, (float)Float.MAX_VALUE), this.explosionFire, this.explosionBlockInteraction(), SoundEvents.f_11913_, this.m_5720_(), (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), this.explosionDamage, true, false);
                this.m_146870_();
            }
        }
    }

    public boolean m_7349_(Explosion p_19987_, BlockGetter p_19988_, BlockPos p_19989_, BlockState p_19990_, float p_19991_) {
        return p_19990_.getExplosionResistance(p_19988_, p_19989_, p_19987_) <= 7.0f && !p_19990_.m_204336_(TagInit.Blocks.UNBREAKABLE);
    }

    protected void m_5790_(EntityHitResult p_37216_) {
        if (!(p_37216_.m_82443_() instanceof MutantBlazeShieldPart)) {
            super.m_5790_(p_37216_);
            if (!this.f_19853_.f_46443_) {
                Entity entity = p_37216_.m_82443_();
                Entity entity1 = this.m_37282_();
                if (this.canHarm(entity)) {
                    if (this.ignoresInvulTime) {
                        entity.f_19802_ = 0;
                    }
                    entity.m_6469_(DamageSourceInit.fireResBypassingFireball((Entity)this, entity1), this.damage);
                    entity.m_20254_(this.fireLength);
                    if (entity1 instanceof LivingEntity) {
                        this.m_19970_((LivingEntity)entity1, entity);
                    }
                }
            }
        }
    }

    public boolean m_6469_(DamageSource p_36839_, float p_36840_) {
        if (p_36839_.m_7640_() != null && p_36839_.m_7640_() instanceof MutantBlazeFireball) {
            MiscUtils.customExplosion(this.f_19853_, (Entity)(this.m_37282_() != null ? this.m_37282_() : this), DamageSource.m_19373_(this.m_37282_() != null && this.m_37282_() instanceof LivingEntity ? (LivingEntity)this.m_37282_() : null).m_19366_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5f, false, Explosion.BlockInteraction.NONE, SoundEvents.f_11913_, this.m_5720_(), (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), 5.0f, true, false);
            this.m_146870_();
            return false;
        }
        return super.m_6469_(p_36839_, p_36840_);
    }

    public Explosion.BlockInteraction explosionBlockInteraction() {
        if (this.griefing) {
            if (this.griefingDropsBlocks) {
                return Explosion.BlockInteraction.BREAK;
            }
            return Explosion.BlockInteraction.DESTROY;
        }
        return Explosion.BlockInteraction.NONE;
    }

    boolean canHarm(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_FIREBALL_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantBlaze)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantBlaze));
    }

    boolean canHit(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_FIREBALL_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantBlaze)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantBlaze));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

